/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.types;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum AccessProtocol {
    CIFS("cifs"),
    GLUSTER("gluster"),
    NFS("nfs");

    private static final Logger log;
    private String image;

    private AccessProtocol(String image) {
        this.image = image;
    }

    public String value() {
        return this.image;
    }

    public static AccessProtocol fromValue(String value) {
        try {
            return AccessProtocol.valueOf(value.toUpperCase());
        }
        catch (IllegalArgumentException exception) {
            log.error("The string '" + value + "' isn't a valid value for the 'AccessProtocol' enumerated type. Valid values are 'cifs', 'gluster' and 'nfs'.", (Throwable)exception);
            return null;
        }
    }

    static {
        log = LoggerFactory.getLogger(AccessProtocol.class);
    }
}

