/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.xml;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.ovirt.api.metamodel.runtime.util.ArrayListWithHref;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.engine.sdk4.internal.containers.VirtualNumaNodeContainer;
import org.ovirt.engine.sdk4.internal.xml.XmlCpuReader;
import org.ovirt.engine.sdk4.internal.xml.XmlHostReader;
import org.ovirt.engine.sdk4.internal.xml.XmlNumaNodePinReader;
import org.ovirt.engine.sdk4.internal.xml.XmlStatisticReader;
import org.ovirt.engine.sdk4.internal.xml.XmlVmReader;
import org.ovirt.engine.sdk4.types.Statistic;
import org.ovirt.engine.sdk4.types.VirtualNumaNode;

public class XmlVirtualNumaNodeReader {
    public static VirtualNumaNode readOne(XmlReader reader) {
        String name;
        if (!reader.forward()) {
            return null;
        }
        VirtualNumaNodeContainer object = new VirtualNumaNodeContainer();
        block36: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            name = reader.getAttributeLocalName(i);
            String image = reader.getAttributeValue(i);
            switch (name) {
                case "href": {
                    object.href(image);
                    continue block36;
                }
                case "id": {
                    object.id(image);
                    continue block36;
                }
            }
        }
        ArrayList<String[]> links = new ArrayList<String[]>();
        reader.next();
        block37: while (reader.forward()) {
            switch (name = reader.getLocalName()) {
                case "comment": {
                    object.comment(reader.readString());
                    continue block37;
                }
                case "cpu": {
                    object.cpu(XmlCpuReader.readOne(reader));
                    continue block37;
                }
                case "description": {
                    object.description(reader.readString());
                    continue block37;
                }
                case "host": {
                    object.host(XmlHostReader.readOne(reader));
                    continue block37;
                }
                case "index": {
                    object.index(reader.readInteger());
                    continue block37;
                }
                case "memory": {
                    object.memory(reader.readInteger());
                    continue block37;
                }
                case "name": {
                    object.name(reader.readString());
                    continue block37;
                }
                case "node_distance": {
                    object.nodeDistance(reader.readString());
                    continue block37;
                }
                case "numa_node_pins": {
                    object.numaNodePins(XmlNumaNodePinReader.readMany(reader));
                    continue block37;
                }
                case "statistics": {
                    object.statistics(XmlStatisticReader.readMany(reader));
                    continue block37;
                }
                case "vm": {
                    object.vm(XmlVmReader.readOne(reader));
                    continue block37;
                }
                case "link": {
                    String rel = reader.getAttributeValue("rel");
                    String href = reader.getAttributeValue("href");
                    if (rel != null && href != null) {
                        links.add(new String[]{rel, href});
                    }
                    reader.skip();
                    continue block37;
                }
            }
            reader.skip();
        }
        if (links != null) {
            for (String[] link : links) {
                XmlVirtualNumaNodeReader.processLink(object, link);
            }
        }
        reader.next();
        return object;
    }

    public static Iterator<VirtualNumaNode> iterateMany(final XmlReader reader) {
        return new Iterator<VirtualNumaNode>(){
            private boolean first = true;

            @Override
            public void remove() {
            }

            @Override
            public boolean hasNext() {
                if (this.first) {
                    if (!reader.forward()) {
                        return false;
                    }
                    reader.next();
                    this.first = false;
                }
                if (!reader.forward()) {
                    reader.next();
                    return false;
                }
                return true;
            }

            @Override
            public VirtualNumaNode next() {
                VirtualNumaNode next = XmlVirtualNumaNodeReader.readOne(reader);
                if (next == null) {
                    throw new NoSuchElementException();
                }
                return next;
            }
        };
    }

    public static List<VirtualNumaNode> readMany(XmlReader reader) {
        ArrayList<VirtualNumaNode> list = new ArrayList<VirtualNumaNode>();
        Iterator<VirtualNumaNode> iterator = XmlVirtualNumaNodeReader.iterateMany(reader);
        while (iterator.hasNext()) {
            list.add(iterator.next());
        }
        return list;
    }

    private static void processLink(VirtualNumaNodeContainer object, String[] link) {
        String rel = link[0];
        String href = link[1];
        if (href != null) {
            switch (rel) {
                case "statistics": {
                    ArrayListWithHref<Statistic> list = new ArrayListWithHref<Statistic>(object.statistics());
                    list.href(href);
                    object.statistics(list);
                    break;
                }
            }
        }
    }
}

