/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.xml;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.engine.sdk4.internal.containers.ImageTransferContainer;
import org.ovirt.engine.sdk4.internal.xml.XmlDiskReader;
import org.ovirt.engine.sdk4.internal.xml.XmlDiskSnapshotReader;
import org.ovirt.engine.sdk4.internal.xml.XmlHostReader;
import org.ovirt.engine.sdk4.internal.xml.XmlImageReader;
import org.ovirt.engine.sdk4.internal.xml.XmlImageTransferDirectionReader;
import org.ovirt.engine.sdk4.internal.xml.XmlImageTransferPhaseReader;
import org.ovirt.engine.sdk4.types.ImageTransfer;

public class XmlImageTransferReader {
    public static ImageTransfer readOne(XmlReader reader) {
        String name;
        if (!reader.forward()) {
            return null;
        }
        ImageTransferContainer object = new ImageTransferContainer();
        block36: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            name = reader.getAttributeLocalName(i);
            String image = reader.getAttributeValue(i);
            switch (name) {
                case "href": {
                    object.href(image);
                    continue block36;
                }
                case "id": {
                    object.id(image);
                    continue block36;
                }
            }
        }
        ArrayList<String[]> links = new ArrayList<String[]>();
        reader.next();
        block37: while (reader.forward()) {
            switch (name = reader.getLocalName()) {
                case "comment": {
                    object.comment(reader.readString());
                    continue block37;
                }
                case "description": {
                    object.description(reader.readString());
                    continue block37;
                }
                case "direction": {
                    object.direction(XmlImageTransferDirectionReader.readOne(reader));
                    continue block37;
                }
                case "disk": {
                    object.disk(XmlDiskReader.readOne(reader));
                    continue block37;
                }
                case "host": {
                    object.host(XmlHostReader.readOne(reader));
                    continue block37;
                }
                case "image": {
                    object.image(XmlImageReader.readOne(reader));
                    continue block37;
                }
                case "name": {
                    object.name(reader.readString());
                    continue block37;
                }
                case "phase": {
                    object.phase(XmlImageTransferPhaseReader.readOne(reader));
                    continue block37;
                }
                case "proxy_url": {
                    object.proxyUrl(reader.readString());
                    continue block37;
                }
                case "signed_ticket": {
                    object.signedTicket(reader.readString());
                    continue block37;
                }
                case "snapshot": {
                    object.snapshot(XmlDiskSnapshotReader.readOne(reader));
                    continue block37;
                }
                case "link": {
                    String rel = reader.getAttributeValue("rel");
                    String href = reader.getAttributeValue("href");
                    if (rel != null && href != null) {
                        links.add(new String[]{rel, href});
                    }
                    reader.skip();
                    continue block37;
                }
            }
            reader.skip();
        }
        if (links != null) {
            for (String[] link : links) {
                XmlImageTransferReader.processLink(object, link);
            }
        }
        reader.next();
        return object;
    }

    public static Iterator<ImageTransfer> iterateMany(final XmlReader reader) {
        return new Iterator<ImageTransfer>(){
            private boolean first = true;

            @Override
            public void remove() {
            }

            @Override
            public boolean hasNext() {
                if (this.first) {
                    if (!reader.forward()) {
                        return false;
                    }
                    reader.next();
                    this.first = false;
                }
                if (!reader.forward()) {
                    reader.next();
                    return false;
                }
                return true;
            }

            @Override
            public ImageTransfer next() {
                ImageTransfer next = XmlImageTransferReader.readOne(reader);
                if (next == null) {
                    throw new NoSuchElementException();
                }
                return next;
            }
        };
    }

    public static List<ImageTransfer> readMany(XmlReader reader) {
        ArrayList<ImageTransfer> list = new ArrayList<ImageTransfer>();
        Iterator<ImageTransfer> iterator = XmlImageTransferReader.iterateMany(reader);
        while (iterator.hasNext()) {
            list.add(iterator.next());
        }
        return list;
    }

    private static void processLink(ImageTransferContainer object, String[] link) {
    }
}

