/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.xml;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.ovirt.api.metamodel.runtime.util.ArrayListWithHref;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.engine.sdk4.internal.containers.AffinityGroupContainer;
import org.ovirt.engine.sdk4.internal.xml.XmlAffinityRuleReader;
import org.ovirt.engine.sdk4.internal.xml.XmlClusterReader;
import org.ovirt.engine.sdk4.internal.xml.XmlHostReader;
import org.ovirt.engine.sdk4.internal.xml.XmlVmReader;
import org.ovirt.engine.sdk4.types.AffinityGroup;
import org.ovirt.engine.sdk4.types.Host;
import org.ovirt.engine.sdk4.types.Vm;

public class XmlAffinityGroupReader {
    public static AffinityGroup readOne(XmlReader reader) {
        String name;
        if (!reader.forward()) {
            return null;
        }
        AffinityGroupContainer object = new AffinityGroupContainer();
        block34: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            name = reader.getAttributeLocalName(i);
            String image = reader.getAttributeValue(i);
            switch (name) {
                case "href": {
                    object.href(image);
                    continue block34;
                }
                case "id": {
                    object.id(image);
                    continue block34;
                }
            }
        }
        ArrayList<String[]> links = new ArrayList<String[]>();
        reader.next();
        block35: while (reader.forward()) {
            switch (name = reader.getLocalName()) {
                case "cluster": {
                    object.cluster(XmlClusterReader.readOne(reader));
                    continue block35;
                }
                case "comment": {
                    object.comment(reader.readString());
                    continue block35;
                }
                case "description": {
                    object.description(reader.readString());
                    continue block35;
                }
                case "enforcing": {
                    object.enforcing(reader.readBoolean());
                    continue block35;
                }
                case "hosts": {
                    object.hosts(XmlHostReader.readMany(reader));
                    continue block35;
                }
                case "hosts_rule": {
                    object.hostsRule(XmlAffinityRuleReader.readOne(reader));
                    continue block35;
                }
                case "name": {
                    object.name(reader.readString());
                    continue block35;
                }
                case "positive": {
                    object.positive(reader.readBoolean());
                    continue block35;
                }
                case "vms": {
                    object.vms(XmlVmReader.readMany(reader));
                    continue block35;
                }
                case "vms_rule": {
                    object.vmsRule(XmlAffinityRuleReader.readOne(reader));
                    continue block35;
                }
                case "link": {
                    String rel = reader.getAttributeValue("rel");
                    String href = reader.getAttributeValue("href");
                    if (rel != null && href != null) {
                        links.add(new String[]{rel, href});
                    }
                    reader.skip();
                    continue block35;
                }
            }
            reader.skip();
        }
        if (links != null) {
            for (String[] link : links) {
                XmlAffinityGroupReader.processLink(object, link);
            }
        }
        reader.next();
        return object;
    }

    public static Iterator<AffinityGroup> iterateMany(final XmlReader reader) {
        return new Iterator<AffinityGroup>(){
            private boolean first = true;

            @Override
            public void remove() {
            }

            @Override
            public boolean hasNext() {
                if (this.first) {
                    if (!reader.forward()) {
                        return false;
                    }
                    reader.next();
                    this.first = false;
                }
                if (!reader.forward()) {
                    reader.next();
                    return false;
                }
                return true;
            }

            @Override
            public AffinityGroup next() {
                AffinityGroup next = XmlAffinityGroupReader.readOne(reader);
                if (next == null) {
                    throw new NoSuchElementException();
                }
                return next;
            }
        };
    }

    public static List<AffinityGroup> readMany(XmlReader reader) {
        ArrayList<AffinityGroup> list = new ArrayList<AffinityGroup>();
        Iterator<AffinityGroup> iterator = XmlAffinityGroupReader.iterateMany(reader);
        while (iterator.hasNext()) {
            list.add(iterator.next());
        }
        return list;
    }

    private static void processLink(AffinityGroupContainer object, String[] link) {
        String rel = link[0];
        String href = link[1];
        if (href != null) {
            switch (rel) {
                case "hosts": {
                    ArrayListWithHref<Host> list = new ArrayListWithHref<Host>(object.hosts());
                    list.href(href);
                    object.hosts(list);
                    break;
                }
                case "vms": {
                    ArrayListWithHref<Vm> list = new ArrayListWithHref<Vm>(object.vms());
                    list.href(href);
                    object.vms(list);
                    break;
                }
            }
        }
    }
}

