/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.containers;

import java.util.List;
import org.ovirt.engine.sdk4.internal.containers.IdentifiedContainer;
import org.ovirt.engine.sdk4.types.OpenStackNetwork;
import org.ovirt.engine.sdk4.types.OpenStackSubnet;

public class OpenStackSubnetContainer
extends IdentifiedContainer
implements OpenStackSubnet {
    private String cidr;
    private List<String> dnsServers;
    private String gateway;
    private String ipVersion;
    private OpenStackNetwork openstackNetwork;

    @Override
    public String cidr() {
        return this.cidr;
    }

    public void cidr(String newCidr) {
        this.cidr = newCidr;
    }

    @Override
    public boolean cidrPresent() {
        return this.cidr != null;
    }

    @Override
    public List<String> dnsServers() {
        return OpenStackSubnetContainer.makeUnmodifiableList(this.dnsServers);
    }

    public void dnsServers(List<String> newDnsServers) {
        this.dnsServers = OpenStackSubnetContainer.makeArrayList(newDnsServers);
    }

    @Override
    public boolean dnsServersPresent() {
        return this.dnsServers != null && !this.dnsServers.isEmpty();
    }

    @Override
    public String gateway() {
        return this.gateway;
    }

    public void gateway(String newGateway) {
        this.gateway = newGateway;
    }

    @Override
    public boolean gatewayPresent() {
        return this.gateway != null;
    }

    @Override
    public String ipVersion() {
        return this.ipVersion;
    }

    public void ipVersion(String newIpVersion) {
        this.ipVersion = newIpVersion;
    }

    @Override
    public boolean ipVersionPresent() {
        return this.ipVersion != null;
    }

    @Override
    public OpenStackNetwork openstackNetwork() {
        return this.openstackNetwork;
    }

    public void openstackNetwork(OpenStackNetwork newOpenstackNetwork) {
        this.openstackNetwork = newOpenstackNetwork;
    }

    @Override
    public boolean openstackNetworkPresent() {
        return this.openstackNetwork != null;
    }
}

