/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.builders;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.ovirt.engine.sdk4.builders.ClusterBuilder;
import org.ovirt.engine.sdk4.builders.DataCenterBuilder;
import org.ovirt.engine.sdk4.builders.DnsResolverConfigurationBuilder;
import org.ovirt.engine.sdk4.builders.IpBuilder;
import org.ovirt.engine.sdk4.builders.NetworkLabelBuilder;
import org.ovirt.engine.sdk4.builders.PermissionBuilder;
import org.ovirt.engine.sdk4.builders.QosBuilder;
import org.ovirt.engine.sdk4.builders.VlanBuilder;
import org.ovirt.engine.sdk4.builders.VnicProfileBuilder;
import org.ovirt.engine.sdk4.internal.containers.NetworkContainer;
import org.ovirt.engine.sdk4.types.Cluster;
import org.ovirt.engine.sdk4.types.DataCenter;
import org.ovirt.engine.sdk4.types.DnsResolverConfiguration;
import org.ovirt.engine.sdk4.types.Ip;
import org.ovirt.engine.sdk4.types.Network;
import org.ovirt.engine.sdk4.types.NetworkLabel;
import org.ovirt.engine.sdk4.types.NetworkStatus;
import org.ovirt.engine.sdk4.types.NetworkUsage;
import org.ovirt.engine.sdk4.types.Permission;
import org.ovirt.engine.sdk4.types.Qos;
import org.ovirt.engine.sdk4.types.Vlan;
import org.ovirt.engine.sdk4.types.VnicProfile;

public class NetworkBuilder {
    private Cluster cluster;
    private String comment;
    private DataCenter dataCenter;
    private String description;
    private Boolean display;
    private DnsResolverConfiguration dnsResolverConfiguration;
    private String href;
    private String id;
    private Ip ip;
    private BigInteger mtu;
    private String name;
    private List<NetworkLabel> networkLabels;
    private List<Permission> permissions;
    private Boolean profileRequired;
    private Qos qos;
    private Boolean required;
    private NetworkStatus status;
    private Boolean stp;
    private List<NetworkUsage> usages;
    private Vlan vlan;
    private List<VnicProfile> vnicProfiles;

    public NetworkBuilder cluster(Cluster newCluster) {
        this.cluster = newCluster;
        return this;
    }

    public NetworkBuilder cluster(ClusterBuilder newCluster) {
        this.cluster = newCluster == null ? null : newCluster.build();
        return this;
    }

    public NetworkBuilder comment(String newComment) {
        this.comment = newComment;
        return this;
    }

    public NetworkBuilder dataCenter(DataCenter newDataCenter) {
        this.dataCenter = newDataCenter;
        return this;
    }

    public NetworkBuilder dataCenter(DataCenterBuilder newDataCenter) {
        this.dataCenter = newDataCenter == null ? null : newDataCenter.build();
        return this;
    }

    public NetworkBuilder description(String newDescription) {
        this.description = newDescription;
        return this;
    }

    public NetworkBuilder display(boolean newDisplay) {
        this.display = newDisplay;
        return this;
    }

    public NetworkBuilder display(Boolean newDisplay) {
        this.display = newDisplay;
        return this;
    }

    public NetworkBuilder dnsResolverConfiguration(DnsResolverConfiguration newDnsResolverConfiguration) {
        this.dnsResolverConfiguration = newDnsResolverConfiguration;
        return this;
    }

    public NetworkBuilder dnsResolverConfiguration(DnsResolverConfigurationBuilder newDnsResolverConfiguration) {
        this.dnsResolverConfiguration = newDnsResolverConfiguration == null ? null : newDnsResolverConfiguration.build();
        return this;
    }

    public NetworkBuilder href(String newHref) {
        this.href = newHref;
        return this;
    }

    public NetworkBuilder id(String newId) {
        this.id = newId;
        return this;
    }

    public NetworkBuilder ip(Ip newIp) {
        this.ip = newIp;
        return this;
    }

    public NetworkBuilder ip(IpBuilder newIp) {
        this.ip = newIp == null ? null : newIp.build();
        return this;
    }

    public NetworkBuilder mtu(int newMtu) {
        this.mtu = BigInteger.valueOf(newMtu);
        return this;
    }

    public NetworkBuilder mtu(Integer newMtu) {
        this.mtu = newMtu == null ? null : BigInteger.valueOf(newMtu.longValue());
        return this;
    }

    public NetworkBuilder mtu(long newMtu) {
        this.mtu = BigInteger.valueOf(newMtu);
        return this;
    }

    public NetworkBuilder mtu(Long newMtu) {
        this.mtu = newMtu == null ? null : BigInteger.valueOf(newMtu);
        return this;
    }

    public NetworkBuilder mtu(BigInteger newMtu) {
        this.mtu = newMtu;
        return this;
    }

    public NetworkBuilder name(String newName) {
        this.name = newName;
        return this;
    }

    public NetworkBuilder networkLabels(List<NetworkLabel> newNetworkLabels) {
        if (newNetworkLabels != null) {
            if (this.networkLabels == null) {
                this.networkLabels = new ArrayList<NetworkLabel>(newNetworkLabels);
            } else {
                this.networkLabels.addAll(newNetworkLabels);
            }
        }
        return this;
    }

    public NetworkBuilder networkLabels(NetworkLabel ... newNetworkLabels) {
        if (newNetworkLabels != null) {
            if (this.networkLabels == null) {
                this.networkLabels = new ArrayList<NetworkLabel>(newNetworkLabels.length);
            }
            Collections.addAll(this.networkLabels, newNetworkLabels);
        }
        return this;
    }

    public NetworkBuilder networkLabels(NetworkLabelBuilder ... newNetworkLabels) {
        if (newNetworkLabels != null) {
            if (this.networkLabels == null) {
                this.networkLabels = new ArrayList<NetworkLabel>(newNetworkLabels.length);
            }
            for (NetworkLabelBuilder builder : newNetworkLabels) {
                this.networkLabels.add(builder.build());
            }
        }
        return this;
    }

    public NetworkBuilder permissions(List<Permission> newPermissions) {
        if (newPermissions != null) {
            if (this.permissions == null) {
                this.permissions = new ArrayList<Permission>(newPermissions);
            } else {
                this.permissions.addAll(newPermissions);
            }
        }
        return this;
    }

    public NetworkBuilder permissions(Permission ... newPermissions) {
        if (newPermissions != null) {
            if (this.permissions == null) {
                this.permissions = new ArrayList<Permission>(newPermissions.length);
            }
            Collections.addAll(this.permissions, newPermissions);
        }
        return this;
    }

    public NetworkBuilder permissions(PermissionBuilder ... newPermissions) {
        if (newPermissions != null) {
            if (this.permissions == null) {
                this.permissions = new ArrayList<Permission>(newPermissions.length);
            }
            for (PermissionBuilder builder : newPermissions) {
                this.permissions.add(builder.build());
            }
        }
        return this;
    }

    public NetworkBuilder profileRequired(boolean newProfileRequired) {
        this.profileRequired = newProfileRequired;
        return this;
    }

    public NetworkBuilder profileRequired(Boolean newProfileRequired) {
        this.profileRequired = newProfileRequired;
        return this;
    }

    public NetworkBuilder qos(Qos newQos) {
        this.qos = newQos;
        return this;
    }

    public NetworkBuilder qos(QosBuilder newQos) {
        this.qos = newQos == null ? null : newQos.build();
        return this;
    }

    public NetworkBuilder required(boolean newRequired) {
        this.required = newRequired;
        return this;
    }

    public NetworkBuilder required(Boolean newRequired) {
        this.required = newRequired;
        return this;
    }

    public NetworkBuilder status(NetworkStatus newStatus) {
        this.status = newStatus;
        return this;
    }

    public NetworkBuilder stp(boolean newStp) {
        this.stp = newStp;
        return this;
    }

    public NetworkBuilder stp(Boolean newStp) {
        this.stp = newStp;
        return this;
    }

    public NetworkBuilder usages(List<NetworkUsage> newUsages) {
        if (newUsages != null) {
            if (this.usages == null) {
                this.usages = new ArrayList<NetworkUsage>(newUsages);
            } else {
                this.usages.addAll(newUsages);
            }
        }
        return this;
    }

    public NetworkBuilder usages(NetworkUsage ... newUsages) {
        if (newUsages != null) {
            if (this.usages == null) {
                this.usages = new ArrayList<NetworkUsage>(newUsages.length);
            }
            Collections.addAll(this.usages, newUsages);
        }
        return this;
    }

    public NetworkBuilder vlan(Vlan newVlan) {
        this.vlan = newVlan;
        return this;
    }

    public NetworkBuilder vlan(VlanBuilder newVlan) {
        this.vlan = newVlan == null ? null : newVlan.build();
        return this;
    }

    public NetworkBuilder vnicProfiles(List<VnicProfile> newVnicProfiles) {
        if (newVnicProfiles != null) {
            if (this.vnicProfiles == null) {
                this.vnicProfiles = new ArrayList<VnicProfile>(newVnicProfiles);
            } else {
                this.vnicProfiles.addAll(newVnicProfiles);
            }
        }
        return this;
    }

    public NetworkBuilder vnicProfiles(VnicProfile ... newVnicProfiles) {
        if (newVnicProfiles != null) {
            if (this.vnicProfiles == null) {
                this.vnicProfiles = new ArrayList<VnicProfile>(newVnicProfiles.length);
            }
            Collections.addAll(this.vnicProfiles, newVnicProfiles);
        }
        return this;
    }

    public NetworkBuilder vnicProfiles(VnicProfileBuilder ... newVnicProfiles) {
        if (newVnicProfiles != null) {
            if (this.vnicProfiles == null) {
                this.vnicProfiles = new ArrayList<VnicProfile>(newVnicProfiles.length);
            }
            for (VnicProfileBuilder builder : newVnicProfiles) {
                this.vnicProfiles.add(builder.build());
            }
        }
        return this;
    }

    public Network build() {
        NetworkContainer container = new NetworkContainer();
        container.cluster(this.cluster);
        container.comment(this.comment);
        container.dataCenter(this.dataCenter);
        container.description(this.description);
        container.display(this.display);
        container.dnsResolverConfiguration(this.dnsResolverConfiguration);
        container.href(this.href);
        container.id(this.id);
        container.ip(this.ip);
        container.mtu(this.mtu);
        container.name(this.name);
        container.networkLabels(this.networkLabels);
        container.permissions(this.permissions);
        container.profileRequired(this.profileRequired);
        container.qos(this.qos);
        container.required(this.required);
        container.status(this.status);
        container.stp(this.stp);
        container.usages(this.usages);
        container.vlan(this.vlan);
        container.vnicProfiles(this.vnicProfiles);
        return container;
    }
}

